require 'rubygems'
require 'watir-webdriver'
require 'page-object'
require_relative 'base/base'

class Landing < Base
  include PageObject

  @@CC_Enabled=false;
  def initialize(driver)
    super(driver)
    @@CC_Enabled
  end

  expected_title "VA Appointments"

  button(:login, :id => 'login-btn')
  div(:screen_content, :css=>'.landing-page div.landing-page')
  span(:landing_page_title, :css => '#welcome > span:nth-child(2)')
  p(:text, :css => 'div.content p:nth-of-type(1)')
  ol(:methods_allowed, :css=>'.landing-page ol')
  td(:infoLine1, :css => '.ui-body table tbody tr td:nth-child(1)')
  a(:vaafi_ssoe, :css => '.container a[aria-label=\'Veteran login supporting DSLogon, Symantec, and other CSPs.\']')
  ordered_list(:app_allows_list, :css => '.landing-page>ol')

  a(:cc_present, :id=>'learn-cc')
  #Links on non-authenticated landing page
  #span(:dial911, :css => 'a.device-dial.ui-link > span')
  link(:dial911, :css => 'a[href="911"]')
  link(:dialVeteranCrisisLink, :css => 'a[href="1-800-273-8255"]')

  #Images_link
  link(:dial911Image_link, :id => 'dial-911-btn')
  link(:dialVeteranCrisisImage_link, :id => 'dial-veteran-crisis-line-btn')

  #Images
  image(:dial911Image, :css=>'img[src="app/images/call-911.png"]')
  image(:dialVeteranCrisisImage, :css=>'img[src="app/images/veterans-crisis-line.png"]')

  #Confirmation Modal
  h3(:confirmModalTitle, :css => 'h3.ui-title')
  div(:confirmText, :css => '.ui-popup-container div.ui-content')

  #Confirmation Modal buttons
  button(:return, :id => 'device-dial-return-btn')
  button(:continue, :id => 'device-dial-continue-btn' )

  #VetLink
  elements(:vetLink, :css => ".container a")

  #External Link for View VA Facilties
  link(:vaFacilityLink, :css => 'a[href="https://www.DOMAIN.EX/directory/guide/division.asp?dnum=1"]')

  # landing page for veterans who are not enrolled in VA Health
  h2(:modalTitle, :css => "h2")
  div(:mainContent, :id => "main-content")
  p(:contentLine1, :css => 'div.ui-content p')
  p(:contentLine2, :css =>  'div.ui-content p:nth-of-type(2)')
  li(:contentLine3, :css => 'div.ui-content li:nth-of-type(1)')
  li(:contentLine4, :css => 'div.ui-content li:nth-of-type(2)')
  p(:contentLine5, :css => 'div.ui-content p:nth-of-type(3)')
  p(:contentLine6, :css => 'div.ui-content p:nth-of-type(4)')
  p(:contentLine7, :css => 'div.ui-content p:nth-of-type(5)')
  p(:contentLine8, :css => 'div.ui-content p:nth-of-type(6)')


  link(:va_enrollment_link, :css => 'a')
  link(:va_facility_locator_link, :css => 'div.ui-content p:nth-of-type(6) a')

  def isCCEnabled
    if (self.cc_present?)
      @@CC_Enabled=true
    end

    return @@CC_Enabled
  end
end
T